// background.js
chrome.runtime.onInstalled.addListener(() => {
  chrome.contextMenus.create({
    id: "start_sequence",
    title: "Start Sequence (Save messages for this profile)",
    contexts: ["link", "page"]
  });
});

chrome.contextMenus.onClicked.addListener(async (info, tab) => {
  if (info.menuItemId === "start_sequence") {
    // If click originates from a LinkedIn profile link, post a message to the page
    // so content_script can handle quick focus/editor. Otherwise pass current tab URL.
    const href = info.linkUrl || null;
    try {
      await chrome.scripting.executeScript({
        target: { tabId: tab.id },
        func: (linkUrl) => {
          window.postMessage({ type: 'LI_EXTENSION_START_SEQUENCE', href: linkUrl || location.href }, '*');
        },
        args: [href]
      });
    } catch (e) {
      // fallback: store quick focus and open options page
      chrome.storage.local.set({ _quickFocusProfile: href || tab.url });
      chrome.runtime.openOptionsPage();
    }
  }
});

// Accept messages from content script (badge updates)
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.type === 'updateBadge') {
    const count = message.count || 0;
    chrome.action.setBadgeText({ text: String(count) });
    chrome.action.setBadgeBackgroundColor({ color: '#FF5A5F' });
    sendResponse({ ok: true });
  }
  // keep listener alive if needed
  return true;
});